/**
* \file: VrCaptureAudioChannel.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* Sample audio channel implementation for voice recognition capture
*
* \component: Baidu CarLife
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef BDCL_VRCAPTUREAUDIOCHANNEL_H
#define BDCL_VRCAPTUREAUDIOCHANNEL_H

#include <bdcl/AditAudioSource.h>

namespace adit { namespace bdcl {

class VrCaptureAudioChannel : public IAditAudioSourceCallbacks
{
public:
    VrCaptureAudioChannel(CoreCallbackDealer* inCallbackDealer);
    virtual ~VrCaptureAudioChannel();

    void teardown(void);
private:
    AditAudioSource* mAudioSource;

    /** @brief Callback initiated by Baidu core to start voice wakeup.
     */
    void onMicRecordWakeupStart();

    /** @brief Callback initiated by Baidu core to end voice recording.
     */
    void onMicRecordEnd();

    /** @brief Callback initiated by Baidu core to enter voice recognition phase.
     */
    void onMicRecordRecognitionStart();

    /** @brief Callback initiated by ADIT to inform MC application about an error.
     */
    void onError(bdclErrorCodes inErrorCode);
};

} } /* namespace adit { namespace bdcl { */

#endif /* BDCL_VRCAPTUREAUDIOCHANNEL_H */
